//: Generics
//:
//: Swift code is specific to only one type.
//:
//: This means code can become duplicated, like the example below.
//:
//: -------------------
//:
//: [◀  Previous Page](@previous)  |  [Next Page  ▶](@next)
//:
//: -------------------
//:


// → the problem
func addTwoValues(_ a: Int, _ b: Int) -> Int {
    a + b
}
func addTwoValues(_ a: Double, _ b: Double) -> Double {
    a + b
}
func addTwoValues(_ a: Decimal, _ b: Decimal) -> Decimal {
    a + b
}

// execute these functions
let integerSum = addTwoValues(1, 1)
let doubleSum = addTwoValues(1.0, 1.0)
let decimalSum = addTwoValues(Decimal(1), Decimal(1))


//:
//: -------------------
//:
//: ## Using Swift Generics
//:
//: -------------------
//:


// declare the generic function
func addTwoValuesUsingGenerics<T: AdditiveArithmetic>(_ a: T, _ b: T) -> T {
    a + b
}

// use it
let sum = addTwoValuesUsingGenerics(1, 1)


//:
//: -------------------
//:
//: [◀  Previous Page](@previous)  |  [Next Page  ▶](@next)
//:
//: -------------------
//:
//: ## ![3 Days Of Swift Logo](3DaysIcon146.png) 3 Days Of Swift
//:
//: © Copyright. All rights reserved.
//:
//: 🧕🏻🙋🏽‍♂️👨🏿‍💼👩🏼‍💼👩🏻‍💻💁🏼‍♀️👨🏼‍💼🙋🏻‍♂️🙋🏻‍♀️👩🏼‍💻🙋🏿💁🏽‍♂️🙋🏽‍♀️🙋🏿‍♀️🧕🏾🙋🏼‍♂️
//:
//: Welcome to our community of [3DaysOfSwift.com](https://www.3DaysOfSwift.com) developers!
